# vim:ft=bash

setup () {
    load "bats_helpers/bats-support/load"
    load "bats_helpers/bats-assert/load"
    PATH="$BATS_TEST_DIRNAME/../dist:$PATH"
}

@test "help" {
    run mnpw --help
    assert_success
    assert_output --partial 'usage:'
}

@test "version" {
    run mnpw --version
    assert_success
    assert_output --partial 'mnpw version'
}

@test "silent and verbose" {
    run mnpw --silent --verbose /bin/true
    assert_failure 2
}

@test "true" {
    run mnpw /bin/true
    assert_success
}

@test "command not found" {
    run mnpw --dry-run /foobar
    assert_failure 2
}

@test "warning" {
    run mnpw --dry-run -- /bin/sh -c 'exit 1'
}

@test "critical" {
    run mnpw --dry-run -- /bin/sh -c 'exit 2'
}

@test "unknown" {
    run mnpw --dry-run -- /bin/sh -c 'exit 3'
}

@test "invalid return code" {
    run mnpw --dry-run -- /bin/sh -c 'exit 4'
}

@test "timeout" {
    run mnpw --dry-run --timeout 2 -- /bin/sh -c 'sleep 6'
    assert_failure 2
}

@test "quiet" {
    run mnpw --dry-run --quiet false
    assert_output ''
    run mnpw --dry-run --quiet foobar
    assert_output
}
