"""LDAP authentication webserver to use with Nginx' auth_request."""
# pylint: disable=import-error

from flask import Flask
from flask_simpleldap import LDAP

app = Flask(__name__)
ldap = LDAP(app)


@app.route("/ping")
def ping():
    """Healthcheck."""
    return "pong"


@app.route("/")
def index():
    pass


@app.route("/login")
@ldap.basic_auth_required
def login():
    return "OK"


if __name__ == "__main__":
    app.run()
