"""LDAP authentication webserver to use with Nginx' auth_request."""
# pylint: disable=import-error

import os
from flask import Flask, token
from flask_ldap_auth import login_required

app = Flask(__name__)
app.config["SECRET_KEY"] = os.getenv("SECRET_KEY", os.urandom(16))
app.config["LDAP_AUTH_SERVER"] = os.getenv("LDAP_AUTH_SERVER", "ldapi:///")
app.config["LDAP_TOP_DN"] = os.getenv("LDAP_TOP_DN")
app.register_blueprint(token, url_prefix="/auth")


@app.route("/ping")
def ping():
    """Healthcheck."""
    return "pong"


@app.route("/")
def index():
    pass


@app.route("/login")
@login_required
def login():
    return "OK"


if __name__ == "__main__":
    app.run()
