"""LDAP authentication webserver to use with Nginx' auth_request."""
# pylint: disable=import-error

import os

from flask import Flask
from flask_simpleldap import LDAP

app = Flask(__name__)
app.config["SECRET_KEY"] = os.getenv("SECRET_KEY", os.urandom(16))
app.config["LDAP_SCHEMA"] = os.getenv("LDAP_SCHEMA", "ldapi")
app.config["LDAP_HOST"] = os.getenv("LDAP_HOST", "localhost")
app.config["LDAP_PORT"] = int(os.getenv("LDAP_PORT", "389"))
app.config["LDAP_USERNAME"] = os.getenv("LDAP_USERNAME")
app.config["LDAP_PASSWORD"] = os.getenv("LDAP_PASSWORD")
app.config["LDAP_USE_TLS"] = (
    os.getenv("LDAP_USE_TLS", "false").lower() == "true"
)
app.config["LDAP_REQUIRE_CERT"] = (
    os.getenv("LDAP_REQUIRE_CERT", "false").lower() == "true"
)
app.config["LDAP_BASE_DN"] = os.getenv("LDAP_BASE_DN")
app.config["LDAP_REALM_NAME"] = os.getenv(
    "LDAP_REALM_NAME", "LDAP authentication"
)
app.config["LDAP_OPENLDAP"] = (
    os.getenv("LDAP_OPENLDAP", "false").lower() == "true"
)
app.config["LDAP_OBJECTS_DN"] = os.getenv(
    "LDAP_OBJECTS_DN", "distinguishedName"
)
app.config["LDAP_USER_OBJECT_FILTER"] = os.getenv(
    "LDAP_USER_OBJECT_FILTER", "(&(objectclass=Person)(userPrincipalName=%s))"
)

ldap = LDAP(app)


@app.route("/ping")
def ping():
    """Healthcheck."""
    return "pong"


@app.route("/validate")
@ldap.basic_auth_required
def login():
    """Login to the app, requires LDAP authentication."""
    return "OK"


if __name__ == "__main__":
    app.run()
