resource "aws_route53_zone" "zone" {
  name = "aws.shore.co.il"
}

locals {
  dns_zone_arn          = aws_route53_zone.zone.arn
  dns_zone_id           = aws_route53_zone.zone.zone_id
  dns_zone_name         = aws_route53_zone.zone.name
  dns_zone_name_servers = aws_route53_zone.zone.name_servers
}

output "dns_zone_arn" {
  description = "ARN of the Route53 DNS zone."
  value       = local.dns_zone_arn
}

output "dns_zone_id" {
  description = "ID of the Route53 DNS zone."
  value       = local.dns_zone_id
}

output "dns_zone_name" {
  description = "Name of the Router53 DNS zone."
  value       = local.dns_zone_name
}

output "dns_zone_name_servers" {
  description = "List of name servers of the Route53 DNS zone."
  value       = local.dns_zone_name_servers
}

locals {
  aws_caa_domain_names = [
    "amazon.com",
    "amazontrust.com",
    "awstrust.com",
    "amazonaws.com",
  ]
}

resource "aws_route53_record" "caa" {
  name = local.dns_zone_name
  records = [
    "0 issue \"amazon.com\"",
    "0 issue \"amazontrust.com\"",
    "0 issue \"awstrust.com\"",
    "0 issue \"amazonaws.com\"",
  ]
  ttl     = 86400
  type    = "CAA"
  zone_id = local.dns_zone_id
}
