# Cron docker

A Docker image for running a Cron daemon, actually running
[Supercronic](https://github.com/aptible/supercronic).

## Usage

There are possible usage patterns for this image. The first is using it in a
multi-stage image build as the source of the `supercronic` binary to incorporate
in your own image like so:

```
FROM registry.shore.co.il/cron as supercronic

FROM alpine:latest
COPY --from=supercronic /usr/local/bin/supercronic /usr/local/bin/
```

The other pattern is building on top of this image to run some periodic tasks.
The `ONBUILD` commands will copy the crontab file and validate it. Just copy
whatever scripts and install whatever packages you need, like so:

```
FROM registry.shore.co.il/cron
COPY script /usr/local/bin/
USER root
RUN apk add --update --no-cache aws-cli
USER nobody
```
