# postgres

Just the upstream image but with a healthcheck.

## Backups

The image includes a `backup` and `restore` scripts. The `backup` scripts dumps
all of the databases using `pg_dumpall` and compresses the output using `zstd`
to stdout. This is meant so that backups are run by an external process and it
saves the output to a file, for example:

```
docker exec pg1 backup > /var/backups/pg1/dump.sql.zstd
```

The `restore` script matches the `backup` script in that the it reads a zstd
compress SQL dump from stdin. An example restore:

```
cat dump.sql.zstd | docker exec -i pg2 restore
```

In fact you're able to migrate data from 1 instance to another like so:

```
docker exec pg1 backup | docker exec -i pg2 restore
```
