variable "rate" {
  default     = 15
  description = "How often in minutes the Lambda functions will trigger."
  type        = number
}

output "rate" {
  description = "How often in minutes the Lambda functions will trigger."
  value       = var.rate
}

resource "aws_cloudwatch_event_rule" "schedule" {
  name                = local.Name
  description         = "Schedule to trigger ${local.module} functions in ${local.env}."
  schedule_expression = "rate(${var.rate} minutes)"
  tags                = local.common_tags
}

locals {
  cloudwatch_rule_arn  = aws_cloudwatch_event_rule.schedule.arn
  cloudwatch_rule_name = aws_cloudwatch_event_rule.schedule.name
}

output "cloudwatch_rule_arn" {
  description = "ARN of the CloudWatch schedule rule."
  value       = local.cloudwatch_rule_arn
}

output "cloudwatch_rule_name" {
  description = "Name of the CloudWatch schedule rule."
  value       = local.cloudwatch_rule_name
}

resource "aws_cloudwatch_event_target" "schedule" {
  count = length(local.function_alias_arns)
  arn   = local.function_alias_arns[count.index]
  rule  = local.cloudwatch_rule_name
  depends_on = [
    aws_lambda_permission.cloudwatch,
  ]
}
