from smtplib import SMTP
from utils import Check


class CheckSMTP(Check):
    def __init__(self, port):
        self._port = port

    def _check(self):
        """Check the SMTP port."""
        try:
            smtp = SMTP("smtp.shore.co.il", self._port)
            ehlo = smtp.ehlo()
            if ehlo[0] != 250 or "LOGIN" in ehlo[1].decode().split():
                return [False, f"First EHLO on port {self._port} failed."]
            if smtp.starttls() != (220, b"TLS go ahead"):
                return [False, f"STARTTLS on port {self._port} failed."]
            ehlo = smtp.ehlo()
            if ehlo[0] != 250 or "LOGIN" not in ehlo[1].decode().split():
                return [False, f"Second EHLO on port {self._port} failed."]
            smtp.close()
        except Exception as e:  # pylint: disable=broad-except,invalid-name
            print(str(e))
            return [False, f"SMTP failure on port {self._port}."]
        return [True, f"SMTP on port {self._port} is OK."]


def handler(event, context):  # pylint: disable=unused-argument
    """Lambda event handler."""
    # Port 25 is blocked for Lambda functions. To remove the restriction, the
    # functions need to execute inside a VPN with a NAT gateway. This will
    # raise the cost. For now assume that if the submission port is working,
    # the smtp port is working too (same gateway, same host, same processes).
    for port in [587]:
        CheckSMTP(port).run()


if __name__ == "__main__":
    handler("event", "context")
