resource "aws_sns_topic" "topic" {
  name = local.Name
  tags = local.common_tags
}

locals {
  topic_arn  = aws_sns_topic.topic.arn
  topic_name = aws_sns_topic.topic.name
}

output "topic_arn" {
  description = "ARN of the alerts SNS topic."
  value       = local.topic_arn
}

output "topic_name" {
  description = "Name of the alerts SNS topic."
  value       = local.topic_name
}

variable "subscriptions" {
  default = [
    ["+972528713696", "sms"]
  ]
  description = "A list of subscriptions to the SNS topic."
}

output "subscriptions" {
  description = "A list of subscriptions to the SNS topic."
  value       = var.subscriptions
}

resource "aws_sns_topic_subscription" "subscriptions" {
  count     = length(var.subscriptions)
  endpoint  = element(var.subscriptions[count.index], 0)
  protocol  = element(var.subscriptions[count.index], 1)
  topic_arn = local.topic_arn
}

data "aws_iam_policy_document" "publish" {
  statement {
    effect = "Allow"

    actions = [
      "SNS:Publish",
    ]

    resources = [
      local.topic_arn,
    ]
  }
}

locals {
  sns_publish_policy_doc = data.aws_iam_policy_document.publish.json
}

resource "aws_iam_policy" "publish" {
  name   = "${local.module}-${local.env}-publish"
  policy = local.sns_publish_policy_doc
  tags   = local.common_tags
}

locals {
  publish_policy_arn  = aws_iam_policy.publish.arn
  publish_policy_name = aws_iam_policy.publish.name
}

output "publish_policy_arn" {
  value       = local.publish_policy_arn
  description = "SNS publish IAM policy ARN."
}

output "publish_policy_name" {
  value       = local.publish_policy_name
  description = "SNS publish IAM policy name."
}
