import socket
from utils import Check


class CheckSSH(Check):
    def __init__(self, hostname, port=22):
        self._hostname = hostname
        self._port = port

    def _check(self):
        """Check that an SSH server is available on that host and port."""
        sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        try:
            sock.connect((self._hostname, self._port))
            msg = sock.recv(1024)
            sock.close()
            if msg.startswith(b"SSH-2.0-OpenSSH"):
                return True, f"SSH on {self._hostname}:{self._port} is OK."
            return False, f"SSH on {self._hostname}:{self._port} failed."
        except Exception as e:  # pylint: disable=broad-except,invalid-name
            return False, str(e)


def handler(event, context):  # pylint: disable=unused-argument
    """Lambda event handler."""
    for host in ["ns1.shore.co.il", "ns4.shore.co.il"]:
        CheckSSH(host).run()


if __name__ == "__main__":
    handler("event", "context")
