from utils import check_ssh, publish


def handler(event, context):  # pylint: disable=unused-argument
    """Lambda event handler."""
    for host in ["ns1.shore.co.il", "ns4.shore.co.il"]:
        if check_ssh(host):
            print(f"SSH on {host} is OK.")
        else:
            message = f"SSH on {host} failed."
            print(message)
            publish(message)


if __name__ == "__main__":
    handler("event", "context")
