from smtplib import SMTP
from utils import publish


def check_smtp(port):
    """Check the SMTP port."""
    try:
        smtp = SMTP("smtp.shore.co.il", port)
        ehlo = smtp.ehlo()
        if ehlo[0] != 250 or "LOGIN" in ehlo[1].decode().split():
            return [False, f"First EHLO on port {port} failed."]
        if smtp.starttls() != (220, b"TLS go ahead"):
            return [False, f"STARTTLS on port {port} failed."]
        ehlo = smtp.ehlo()
        if ehlo[0] != 250 or "LOGIN" not in ehlo[1].decode().split():
            return [False, f"Second EHLO on port {port} failed."]
        smtp.close()
    except Exception as e:  # pylint: disable=broad-except,invalid-name
        print(str(e))
        return [False, f"SMTP failure on port {port}."]
    return [True, f"SMTP on port {port} is OK."]


def handler(event, context):  # pylint: disable=unused-argument
    """Lambda event handler."""
    for port in [25, 587]:
        success, message = check_smtp(port)
        print(message)
        if not success:
            publish(message)


if __name__ == "__main__":
    handler("event", "context")
