variable "rate" {
  default     = 15
  description = "How often in minutes the Lambda functions will trigger."
  type        = number
}

output "rate" {
  description = "How often in minutes the Lambda functions will trigger."
  value       = var.rate
}

resource "aws_cloudwatch_event_rule" "schedule" {
  count               = length(local.function_names)
  name                = local.function_names[count.index]
  description         = "Schedule to trigger ${local.function_names[count.index]} functions in ${local.env}."
  schedule_expression = "rate(${var.rate} minutes)"
  tags                = local.common_tags
}

locals {
  cloudwatch_rule_arns  = aws_cloudwatch_event_rule.schedule.*.arn
  cloudwatch_rule_names = aws_cloudwatch_event_rule.schedule.*.name
}

output "cloudwatch_rule_arns" {
  description = "List of ARNs of the CloudWatch schedule rules."
  value       = local.cloudwatch_rule_arns
}

output "cloudwatch_rule_names" {
  description = "List of names of the CloudWatch schedule rules."
  value       = local.cloudwatch_rule_names
}

resource "aws_cloudwatch_event_target" "schedule" {
  count = length(local.function_alias_arns)
  arn   = local.function_alias_arns[count.index]
  rule  = local.cloudwatch_rule_names[count.index]
  depends_on = [
    aws_lambda_permission.cloudwatch,
  ]
}
