terraform {
  backend "http" {}
}

locals {
  env    = terraform.workspace == "default" ? "prod" : terraform.workspace
  module = basename(abspath(path.root))
  common_tags = {
    Environment = local.env
    Module      = local.module
  }
  Name = "${local.module}-${local.env}"
}

output "env" {
  description = "Environment (prod/dev etc.)."
  value       = local.env
}

output "module" {
  description = "The name of the Terraform module, used to tagging resources."
  value       = local.module
}

variable "region" {
  default     = "eu-west-2"
  description = "AWS region."
  type        = string
}

output "region" {
  description = "AWS region."
  value       = var.region
}

provider "aws" {
  region = var.region
}

resource "aws_resourcegroups_group" "group" {
  name = local.Name
  tags = local.common_tags
  resource_query {
    query = <<EOF
{
  "ResourceTypeFilters": [
    "AWS::AllSupported"
  ],
  "TagFilters": [
    {
      "Key": "Module",
      "Values": ["${local.module}"]
    },
    {
      "Key": "Environment",
      "Values": ["${local.env}"]
    }
  ]
}
EOF
  }
}

locals {
  resource_group_arn  = aws_resourcegroups_group.group.arn
  resource_group_name = aws_resourcegroups_group.group.name
}

output "resource_group_arn" {
  description = "ARN of the resource group."
  value       = local.resource_group_arn
}

output "resource_group_name" {
  description = "Name of the resource group."
  value       = local.resource_group_name
}

variable "log_retention" {
  default     = 3
  description = "Number of days to retain logs."
  type        = number
}
