import os
import messagebird  # pylint: disable=import-error


MSGBIRD_ACCESS_KEY = os.environ["MSGBIRD_ACCESS_KEY"]
TO_NUMBER = os.environ["TO_NUMBER"]


# pylint: disable=unused-argument
def handler(event, context):
    message = event["Records"][0]["Sns"]["Message"]
    client = messagebird.Client(MSGBIRD_ACCESS_KEY)
    client.message_create(
        originator="Am I Live",
        recipients=TO_NUMBER,
        body=message,
    )


if __name__ == "__main__":
    handler({"Records": [{"Sns": {"Message": "foo"}}]}, "context")
