"""Check IMAP."""

from imaplib import IMAP4_SSL
from utils import Check


class CheckIMAP(Check):
    def _check(self):
        """Check the IMAP port."""
        try:
            imap = IMAP4_SSL("imap.shore.co.il", 993)
            if "AUTH=PLAIN" not in imap.capabilities:
                return [False, "AUTH not in IMAP capabilities."]
            if imap.noop()[0] != "OK":
                return [False, "NOOP failed in IMAP connection."]
            imap.logout()
        except Exception as e:  # pylint: disable=broad-except,invalid-name
            print(str(e))
            return [False, "IMAP failure."]
        return [True, "IAMP is OK."]


def handler(event, context):  # pylint: disable=unused-argument
    """Lambda event handler."""
    CheckIMAP().run()


if __name__ == "__main__":
    handler("event", "context")
