resource "aws_s3_bucket" "payloads" {
  bucket = local.Name
  tags   = local.common_tags
  acl    = "private"

  versioning {
    enabled = true
  }
}

locals {
  payloads_bucket_arn  = aws_s3_bucket.payloads.arn
  payloads_bucket_name = aws_s3_bucket.payloads.bucket
}

output "payloads_bucket_arn" {
  description = "ARN of the payloads S3 bucket."
  value       = local.payloads_bucket_arn
}

output "payloads_bucket_name" {
  description = "Name of the payloads S3 bucket."
  value       = local.payloads_bucket_name
}

resource "aws_s3_bucket_object" "payload" {
  bucket = local.payloads_bucket_name
  key    = "${local.env}/payload.zip"
  source = "payload.zip"
  etag   = filemd5("payload.zip")
  tags   = local.common_tags
}

locals {
  payload_object_etag    = aws_s3_bucket_object.payload.etag
  payload_object_name    = aws_s3_bucket_object.payload.key
  payload_object_version = aws_s3_bucket_object.payload.version_id
}

output "payload_object_etag" {
  description = "ETag of the payload S3 object."
  value       = local.payload_object_etag
}

output "payload_object_name" {
  description = "Name of the payload S3 object."
  value       = local.payload_object_name
}

output "payload_object_version" {
  description = "Version of the payload S3 object."
  value       = local.payload_object_version
}
