from imaplib import IMAP4_SSL
from utils import publish


def check_imap():
    """Check the IMAP port."""
    try:
        imap = IMAP4_SSL("imap.shore.co.il", 993)
        if "AUTH=PLAIN" not in imap.capabilities:
            return [False, "AUTH not in IMAP capabilities."]
        if imap.noop()[0] != "OK":
            return [False, "NOOP failed in IMAP connection."]
        imap.logout()
    except Exception as e:  # pylint: disable=broad-except,invalid-name
        print(str(e))
        return [False, "IMAP failure."]
    return [True, "IAMP is OK."]


def handler(event, context):  # pylint: disable=unused-argument
    """Lambda event handler."""
    success, message = check_imap()
    print(message)
    if not success:
        publish(message)


if __name__ == "__main__":
    handler("event", "context")
