import socket
from utils import publish


def check_ssh(host, port=22):
    """Check that an SSH server is available on that host and port."""
    sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    try:
        sock.connect((host, port))
        msg = sock.recv(1024)
        sock.close()
        return msg.startswith(b"SSH-2.0-OpenSSH")
    except Exception as e:  # pylint: disable=broad-except,invalid-name
        print(str(e))
        return False


def handler(event, context):  # pylint: disable=unused-argument
    """Lambda event handler."""
    for host in ["ns1.shore.co.il", "ns4.shore.co.il"]:
        if check_ssh(host):
            print(f"SSH on {host} is OK.")
        else:
            message = f"SSH on {host} failed."
            print(message)
            publish(message)


if __name__ == "__main__":
    handler("event", "context")
