resource "aws_cloudwatch_metric_alarm" "invocations" {
  count                     = length(local.function_names)
  alarm_actions             = [local.topic_arn]
  actions_enabled           = true
  alarm_name                = "Invocations alarm for ${local.function_names[count.index]}."
  comparison_operator       = "LessThanThreshold"
  evaluation_periods        = "1"
  insufficient_data_actions = [local.topic_arn]
  metric_name               = "Invocations"
  namespace                 = "AWS/Lambda"
  ok_actions                = [local.topic_arn]
  period                    = (var.rate + 1) * 60
  statistic                 = "Sum"
  tags                      = local.common_tags
  threshold                 = 1

  dimensions = {
    FunctionName = local.function_names[count.index]
  }

  depends_on = [
    aws_cloudwatch_event_target.schedule,
  ]
}

resource "aws_cloudwatch_metric_alarm" "errors" {
  count                     = length(local.function_names)
  alarm_actions             = [local.topic_arn]
  actions_enabled           = true
  alarm_name                = "Errors alarm for ${local.function_names[count.index]}."
  comparison_operator       = "GreaterThanThreshold"
  evaluation_periods        = "1"
  insufficient_data_actions = [local.topic_arn]
  metric_name               = "Errors"
  namespace                 = "AWS/Lambda"
  ok_actions                = [local.topic_arn]
  period                    = (var.rate + 1) * 60
  statistic                 = "Sum"
  tags                      = local.common_tags
  threshold                 = 0

  dimensions = {
    FunctionName = local.function_names[count.index]
  }

  depends_on = [
    aws_cloudwatch_event_target.schedule,
  ]
}
