terraform {
  backend "http" {}
}

locals {
  env    = terraform.workspace == "default" ? "prod" : terraform.workspace
  module = basename(abspath(path.root))
  common_tags = {
    Environment = local.env
    Module      = local.module
  }
  Name = "${local.module}-${local.env}"
}

provider "aws" {
  region = var.region
}

provider "template" {}
