# pylint: disable=import-error
import os
import boto3
import requests


TOPIC_ARN = os.getenv("TOPIC_ARN")


def publish(message):
    """Publish an SNS message."""
    client = boto3.client("sns")
    client.publish(TopicArn=TOPIC_ARN, Message=message)


def check_url(url, method="GET", valid_codes=(200)):
    """Checks URL for validity.

    Allows specifying the HTTP method and a list of valid codes."""
    try:
        response = requests.request(method, url, allow_redirects=False)
        return response.status_code in valid_codes
    except Exception:  # pylint: disable=broad-except
        return False
