from utils import check_url, publish


def handler(event, context):  # pylint: disable=unused-argument
    """Lambda event handler."""
    checks = [
        {"url": "http://git.shore.co.il/", "codes": [301, 302]},
        {"url": "https://git.shore.co.il/", "codes": [301, 302]},
        {"url": "https://git.shore.co.il/explore/", "codes": [200]},
    ]

    for check in checks:
        if not check_url(check["url"], valid_codes=check["codes"]):
            message = f"Failed check for {check['url']}."
            print(message)
            publish(message)
        else:
            print(f"{check['url']} is OK.")


if __name__ == "__main__":
    handler("event", "context")
