import os
import boto3  # pylint: disable=import-error
import messagebird  # pylint: disable=import-error


MSGBIRD_ACCESS_KEY = os.environ["MSGBIRD_ACCESS_KEY"]
TO_NUMBER = os.environ["TO_NUMBER"]


def send_notifications():
    """Check if sending SMSes is enabled."""
    try:
        param_path = os.environ["SEND_SMS_NOTIFICATIONS_PARAM"]
        client = boto3.client("ssm")
        param = client.get_parameters_by_path(
            Path=param_path, recursive=False, WithDecryption=False
        )["Parameters"][0]
        return param["Value"].tolower == "true"
    except Exception:  # pylint: disable=broad-except
        return True


# pylint: disable=unused-argument
def handler(event, context):
    if not send_notifications():
        print("Sending notification is disabled.")
        return
    message = event["Records"][0]["Sns"]["Message"]
    client = messagebird.Client(MSGBIRD_ACCESS_KEY)
    client.message_create(
        originator="Am I Live",
        recipients=TO_NUMBER,
        body=message,
    )


if __name__ == "__main__":
    handler({"Records": [{"Sns": {"Message": "foo"}}]}, "context")
