#!/bin/sh
set -eu
syncevolution --configure \
              --template default \
              --sync-property syncURL= \
              --sync-property peerIsClient=1 \
              --sync-property remoteDeviceId=IMEI:$IMEI \
              --sync-property preventSlowSync=False \
              --source-property uri= \
              --source-property sync=none cellphone
syncevolution --configure \
              --source-property type=file:text/vcard:3.0 \
              --source-property evolutionsource=file:///syncevolution/addressbook \
              cellphone addressbook
syncevolution --configure \
              --source-property type=file:text/calendar:2.0 \
              --source-property evolutionsource=file:///syncevolution/calendar \
              cellphone calendar
syncevolution --configure \
              --source-property type=file:text/calendar:2.0 \
              --source-property evolutionsource=file:///syncevolution/todo \
              cellphone todo
syncevolution --configure \
              --source-property type=file:text/plain:1.0 \
              --source-property evolutionsource=file:///syncevolution/memo \
              cellphone memo
syncevolution --configure \
              --source-property type=virtual:text/calendar:2.0 \
              --source-property evolutionsource=calendar,todo \
              cellphone calendar+todo
syncevolution --configure \
              --source-property sync=slow \
              cellphone addressbook calendar todo memo calendar+todo
exec /usr/bin/syncevo-http-server $@
