# implements tab completion for complete (bash), compsys (new zsh) and compctl (old zsh)
# this file is generated by `rake completion`

_travis_complete() {
  case $1 in
  1) _travis_commands;;
  2)
    case "$2" in
      # commands with smart completions (in addition to command line flags)
      help)     _travis_commands;;
      setup)    _travis_setup;;
      settings) _travis_settings;;
      init)     _travis_init;;
      *)        _travis_option;;
    esac;;
  *) _travis_option;;
  esac
}

if type compdef 1>/dev/null 2>/dev/null; then
  compdef _travis travis
  _travis()          { _travis_complete $((${#words} - 1)) "${words[2]}"; }
  _travis_commands() { list=(accounts:"displays accounts and their subscription status" branches:"displays the most recent build for each branch" cache:"lists or deletes repository caches" cancel:"cancels a job or build" console:"interactive shell" disable:"disables a project" enable:"enables a project" encrypt:"encrypts values for the .travis.yml" encrypt-file:"encrypts a file and adds decryption steps to .travis.yml" endpoint:"displays or changes the API endpoint" env:"show or modify build environment variables" help:"helps you out when in dire need of information" history:"displays a projects build history" init:"generates a .travis.yml and enables the project" lint:"display warnings for a .travis.yml" login:"authenticates against the API and stores the token" logout:"deletes the stored API token" logs:"streams test logs" monitor:"live monitor for what's going on" open:"opens a build or job in the browser" pubkey:"prints out a repository's public key" raw:"makes an (authenticated) API call and prints out the result" report:"generates a report useful for filing issues" repos:"lists repositories the user has certain permissions on" requests:"lists recent requests" restart:"restarts a build or job" settings:"access repository settings" setup:"sets up an addon or deploy target" show:"displays a build or job" sshkey:"checks, updates or deletes an SSH key" status:"checks status of the latest build" sync:"triggers a new sync with GitHub" token:"outputs the secret API token" version:"outputs the client version" whatsup:"lists most recent builds" whoami:"outputs the current user") _describe -t common-commands 'common commands' list; }
  _travis_setup()    { list=(anynines:"automatic deployment to anynines" appfog:"automatic deployment to Appfog" artifacts:"automatic artifact shipping to S3" biicode:"automatic publish to biicode" cloudcontrol:"automatic deployment to cloudControl" cloudfiles:"automatic pushing to Rackspace Cloud Files" cloudfoundry:"automatic deployment to Cloud Foundry" cloud66:"Automatic deployment to Cloud 66" codedeploy:"triggering a new deployment on Amazon CodeDeploy" deis:"automatic deployment to a deis app" divshot:"deployment to Divshot.io" elasticbeanstalk:"deployment to AWS Elastic Beanstalk" engineyard:"automatic deployment to Engine Yard" gcs:"automatic pushing to Google Cloud Storage" hackage:"automatic deployment of hackage packages" heroku:"automatic deployment to Heroku" modulus:"deployment to Modulus" npm:"automatic release to NPM" ninefold:"Automatic deployment to Ninefold" nodejitsu:"automatic deployment to Nodejitsu" openshift:"automatic deployment to OpenShfit" opsworks:"deployment to OpsWorks" pypi:"automatic deployment to PyPI" releases:"Upload Assets to GitHub Releases" rubygems:"automatic release to RubyGems" s3:"automatic pushing to S3" sauce_connect:"Sauce Connet addon for Sauce Labs integration") _describe -t common-commands 'common commands' list; }
  _travis_settings() { list=(builds_only_with_travis_yml:"Only run builds with a .travis.yml" build_pushes:"Build pushes" build_pull_requests:"Build pull requests" maximum_number_of_builds:"Maximum number of concurrent builds" auto_cancel_pushes:"Cancel older push builds that are not yet running" auto_cancel_pull_requests:"Cancel older pull request builds that are not yet running") _describe -t common-commands 'common commands' list; }
  _travis_init()     { list=(c:'initialize c project' clojure:'initialize clojure project' cpp:'initialize cpp project' erlang:'initialize erlang project' go:'initialize go project' groovy:'initialize groovy project' haskell:'initialize haskell project' java:'initialize java project' node_js:'initialize node_js project' objective-c:'initialize objective-c project' perl:'initialize perl project' php:'initialize php project' python:'initialize python project' ruby:'initialize ruby project' scala:'initialize scala project') _describe -t common-commands 'common commands' list; }
  _travis_option()   {
    case "${words[2]}" in
      accounts)  _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" '*:file:_files' && return 0;;
      branches)  _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" "-r[repository to use (will try to detect from current git clone)]" "--repo[repository to use (will try to detect from current git clone)]" "-R[like --repo, but remembers value for current directory]" "--store-repo[like --repo, but remembers value for current directory]" '*:file:_files' && return 0;;
      cache)     _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" "-r[repository to use (will try to detect from current git clone)]" "--repo[repository to use (will try to detect from current git clone)]" "-R[like --repo, but remembers value for current directory]" "--store-repo[like --repo, but remembers value for current directory]" "-d[delete listed caches]" "--delete[delete listed caches]" "-b[only list/delete caches on given branch]" "--branch[only list/delete caches on given branch]" "-m[only list/delete caches where slug matches given string]" "--match[only list/delete caches where slug matches given string]" "-f[do not ask user to confirm deleting the caches]" "--force[do not ask user to confirm deleting the caches]" '*:file:_files' && return 0;;
      cancel)    _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" "-r[repository to use (will try to detect from current git clone)]" "--repo[repository to use (will try to detect from current git clone)]" "-R[like --repo, but remembers value for current directory]" "--store-repo[like --repo, but remembers value for current directory]" '*:file:_files' && return 0;;
      console)   _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" "-x[run line of ruby]" "--eval[run line of ruby]" '*:file:_files' && return 0;;
      disable)   _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" "-r[repository to use (will try to detect from current git clone)]" "--repo[repository to use (will try to detect from current git clone)]" "-R[like --repo, but remembers value for current directory]" "--store-repo[like --repo, but remembers value for current directory]" '*:file:_files' && return 0;;
      enable)    _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" "-r[repository to use (will try to detect from current git clone)]" "--repo[repository to use (will try to detect from current git clone)]" "-R[like --repo, but remembers value for current directory]" "--store-repo[like --repo, but remembers value for current directory]" "-s[don't trigger a sync if the repo is unknown]" "--skip-sync[don't trigger a sync if the repo is unknown]" '*:file:_files' && return 0;;
      encrypt)   _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" "-r[repository to use (will try to detect from current git clone)]" "--repo[repository to use (will try to detect from current git clone)]" "-R[like --repo, but remembers value for current directory]" "--store-repo[like --repo, but remembers value for current directory]" "-a[adds it to .travis.yml under KEY (default: env.global)]" "--add[adds it to .travis.yml under KEY (default: env.global)]" "-s[treat each line as a separate input]" "--split[treat each line as a separate input]" "--no-split[treat each line as a separate input]" "-p[don't override existing values, instead treat as list]" "--append[don't override existing values, instead treat as list]" "-x[override existing value]" "--override[override existing value]" '*:file:_files' && return 0;;
      encrypt-file) _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" "-r[repository to use (will try to detect from current git clone)]" "--repo[repository to use (will try to detect from current git clone)]" "-R[like --repo, but remembers value for current directory]" "--store-repo[like --repo, but remembers value for current directory]" "-K[encryption key to be used (randomly generated otherwise)]" "--key[encryption key to be used (randomly generated otherwise)]" "--iv[encryption IV to be used (randomly generated otherwise)]" "-d[decrypt the file instead of encrypting it, requires key and iv]" "--decrypt[decrypt the file instead of encrypting it, requires key and iv]" "-f[override output file if it exists]" "--force[override output file if it exists]" "-p[print (possibly generated) key and iv]" "--print-key[print (possibly generated) key and iv]" "-w[where to write the decrypted file to on the Travis CI VM]" "--decrypt-to[where to write the decrypted file to on the Travis CI VM]" "-a[automatically add command to .travis.yml (default stage is before_install)]" "--add[automatically add command to .travis.yml (default stage is before_install)]" '*:file:_files' && return 0;;
      endpoint)  _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" "--drop-default[delete stored default endpoint]" "--set-default[store endpoint as global default]" "--github[display github endpoint]" '*:file:_files' && return 0;;
      env)       _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" "-r[repository to use (will try to detect from current git clone)]" "--repo[repository to use (will try to detect from current git clone)]" "-R[like --repo, but remembers value for current directory]" "--store-repo[like --repo, but remembers value for current directory]" "-P[make new values public]" "--public[make new values public]" "--no-public[make new values public]" "-p[make new values private]" "--private[make new values private]" "--no-private[make new values private]" "-u[do not escape values]" "--unescape[do not escape values]" "--no-unescape[do not escape values]" "-f[do not ask for confirmation when clearing out all variables]" "--force[do not ask for confirmation when clearing out all variables]" '*:file:_files' && return 0;;
      help)      _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" '*:file:_files' && return 0;;
      history)   _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" "-r[repository to use (will try to detect from current git clone)]" "--repo[repository to use (will try to detect from current git clone)]" "-R[like --repo, but remembers value for current directory]" "--store-repo[like --repo, but remembers value for current directory]" "-a[Only show history after a given build number]" "--after[Only show history after a given build number]" "-p[Only show history for the given Pull Request]" "--pull-request[Only show history for the given Pull Request]" "-b[Only show history for the given branch]" "--branch[Only show history for the given branch]" "-l[Maximum number of history items]" "--limit[Maximum number of history items]" "-d[Include date in output]" "--date[Include date in output]" "-c[Include committer in output]" "--committer[Include committer in output]" "--all[Display all history items]" "--no-all[Display all history items]" '*:file:_files' && return 0;;
      init)      _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" "-r[repository to use (will try to detect from current git clone)]" "--repo[repository to use (will try to detect from current git clone)]" "-R[like --repo, but remembers value for current directory]" "--store-repo[like --repo, but remembers value for current directory]" "-s[don't trigger a sync if the repo is unknown]" "--skip-sync[don't trigger a sync if the repo is unknown]" "-f[override .travis.yml if it already exists]" "--force[override .travis.yml if it already exists]" "-k[do not enable project, only add .travis.yml]" "--skip-enable[do not enable project, only add .travis.yml]" "-p[print generated config instead of writing to file]" "--print-conf[print generated config instead of writing to file]" "--script[sets script option in .travis.yml (can be used more than once)]" "--before-script[sets before_script option in .travis.yml (can be used more than once)]" "--after-script[sets after_script option in .travis.yml (can be used more than once)]" "--after-success[sets after_success option in .travis.yml (can be used more than once)]" "--install[sets install option in .travis.yml (can be used more than once)]" "--before-install[sets before_install option in .travis.yml (can be used more than once)]" "--compiler[sets compiler option in .travis.yml (can be used more than once)]" "--otp-release[sets otp_release option in .travis.yml (can be used more than once)]" "--go[sets go option in .travis.yml (can be used more than once)]" "--jdk[sets jdk option in .travis.yml (can be used more than once)]" "--node-js[sets node_js option in .travis.yml (can be used more than once)]" "--perl[sets perl option in .travis.yml (can be used more than once)]" "--php[sets php option in .travis.yml (can be used more than once)]" "--python[sets python option in .travis.yml (can be used more than once)]" "--rvm[sets rvm option in .travis.yml (can be used more than once)]" "--scala[sets scala option in .travis.yml (can be used more than once)]" "--env[sets env option in .travis.yml (can be used more than once)]" "--gemfile[sets gemfile option in .travis.yml (can be used more than once)]" '*:file:_files' && return 0;;
      lint)      _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" "-q[does not print anything]" "--quiet[does not print anything]" "--no-quiet[does not print anything]" "-x[sets the exit code to 1 if there are warning]" "--exit-code[sets the exit code to 1 if there are warning]" "--no-exit-code[sets the exit code to 1 if there are warning]" '*:file:_files' && return 0;;
      login)     _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" "-g[identify by GitHub token]" "--github-token[identify by GitHub token]" "-T[try to figure out who you are automatically (might send another apps token to Travis, token will not be stored)]" "--auto-token[try to figure out who you are automatically (might send another apps token to Travis, token will not be stored)]" "-p[try to load password from OSX keychain (will not be stored)]" "--auto-password[try to load password from OSX keychain (will not be stored)]" "-a[shorthand for --auto-token --auto-password]" "--auto[shorthand for --auto-token --auto-password]" "-u[user to log in as]" "--user[user to log in as]" "-M[do not use interactive login]" "--no-manual[do not use interactive login]" "--list-github-token[instead of actually logging in, list found GitHub tokens]" "--skip-token-check[don't verify the token with github]" '*:file:_files' && return 0;;
      logout)    _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" '*:file:_files' && return 0;;
      logs)      _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" "-r[repository to use (will try to detect from current git clone)]" "--repo[repository to use (will try to detect from current git clone)]" "-R[like --repo, but remembers value for current directory]" "--store-repo[like --repo, but remembers value for current directory]" "-d[remove logs]" "--delete[remove logs]" "-f[do not ask user to confirm deleting the logs]" "--force[do not ask user to confirm deleting the logs]" "--stream[only print current logs, do not stream]" "--no-stream[only print current logs, do not stream]" '*:file:_files' && return 0;;
      monitor)   _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" "-m[Only monitor my own repositories]" "--my-repos[Only monitor my own repositories]" "-r[monitor given repository (can be used more than once)]" "--repo[monitor given repository (can be used more than once)]" "-n[send out desktop notifications (optional type: osx, growl, libnotify)]" "--notify[send out desktop notifications (optional type: osx, growl, libnotify)]" "--no-notify[send out desktop notifications (optional type: osx, growl, libnotify)]" "-b[only monitor builds, not jobs]" "--builds[only monitor builds, not jobs]" "-p[monitor push events]" "--push[monitor push events]" "-P[monitor pull request events]" "--pull[monitor pull request events]" '*:file:_files' && return 0;;
      open)      _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" "-r[repository to use (will try to detect from current git clone)]" "--repo[repository to use (will try to detect from current git clone)]" "-R[like --repo, but remembers value for current directory]" "--store-repo[like --repo, but remembers value for current directory]" "-g[Open the corresponding project, compare view or pull request on GitHub]" "--github[Open the corresponding project, compare view or pull request on GitHub]" "-p[Print out the URL instead of opening it in a browser]" "--print[Print out the URL instead of opening it in a browser]" '*:file:_files' && return 0;;
      pubkey)    _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" "-r[repository to use (will try to detect from current git clone)]" "--repo[repository to use (will try to detect from current git clone)]" "-R[like --repo, but remembers value for current directory]" "--store-repo[like --repo, but remembers value for current directory]" "-p[encode in format used by pem]" "--pem[encode in format used by pem]" "-f[display fingerprint]" "--fingerprint[display fingerprint]" '*:file:_files' && return 0;;
      raw)       _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" "--json[display as json]" "--no-json[display as json]" '*:file:_files' && return 0;;
      report)    _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" "-r[include repositories in report]" "--known-repos[include repositories in report]" '*:file:_files' && return 0;;
      repos)     _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" "-m[only list repositories matching the given pattern (shell style)]" "--match[only list repositories matching the given pattern (shell style)]" "-o[only list repos for a certain owner]" "--owner[only list repos for a certain owner]" "-n[only list repos with a given name]" "--name[only list repos with a given name]" "-a[only list active repositories]" "--active[only list active repositories]" "-A[only list inactive repositories]" "--inactive[only list inactive repositories]" "-d[only list repos with (or without) admin access]" "--admin[only list repos with (or without) admin access]" "-D[only list repos without admin access]" "--no-admin[only list repos without admin access]" '*:file:_files' && return 0;;
      requests)  _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" "-r[repository to use (will try to detect from current git clone)]" "--repo[repository to use (will try to detect from current git clone)]" "-R[like --repo, but remembers value for current directory]" "--store-repo[like --repo, but remembers value for current directory]" "-l[Maximum number requests to display]" "--limit[Maximum number requests to display]" '*:file:_files' && return 0;;
      restart)   _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" "-r[repository to use (will try to detect from current git clone)]" "--repo[repository to use (will try to detect from current git clone)]" "-R[like --repo, but remembers value for current directory]" "--store-repo[like --repo, but remembers value for current directory]" '*:file:_files' && return 0;;
      settings)  _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" "-r[repository to use (will try to detect from current git clone)]" "--repo[repository to use (will try to detect from current git clone)]" "-R[like --repo, but remembers value for current directory]" "--store-repo[like --repo, but remembers value for current directory]" "--keys[always use setting key instead of description]" "--enable[enable boolean setting(s)]" "-f[disable boolean setting(s)]" "--disable[disable boolean setting(s)]" "-s[set to given value]" "--set[set to given value]" "-c[change settings interactively]" "--configure[change settings interactively]" '*:file:_files' && return 0;;
      setup)     _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" "-r[repository to use (will try to detect from current git clone)]" "--repo[repository to use (will try to detect from current git clone)]" "-R[like --repo, but remembers value for current directory]" "--store-repo[like --repo, but remembers value for current directory]" "-f[override config section if it already exists]" "--force[override config section if it already exists]" '*:file:_files' && return 0;;
      show)      _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" "-r[repository to use (will try to detect from current git clone)]" "--repo[repository to use (will try to detect from current git clone)]" "-R[like --repo, but remembers value for current directory]" "--store-repo[like --repo, but remembers value for current directory]" '*:file:_files' && return 0;;
      sshkey)    _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" "-r[repository to use (will try to detect from current git clone)]" "--repo[repository to use (will try to detect from current git clone)]" "-R[like --repo, but remembers value for current directory]" "--store-repo[like --repo, but remembers value for current directory]" "-D[remove SSH key]" "--delete[remove SSH key]" "-d[set description]" "--description[set description]" "-u[upload key from given file]" "--upload[upload key from given file]" "-s[upload key read from stdin]" "--stdin[upload key read from stdin]" "-c[set exit code depending on key existing]" "--check[set exit code depending on key existing]" "-g[generate SSH key and set up for given GitHub user]" "--generate[generate SSH key and set up for given GitHub user]" "-p[pass phrase to decrypt with when using --upload]" "--passphrase[pass phrase to decrypt with when using --upload]" '*:file:_files' && return 0;;
      status)    _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" "-r[repository to use (will try to detect from current git clone)]" "--repo[repository to use (will try to detect from current git clone)]" "-R[like --repo, but remembers value for current directory]" "--store-repo[like --repo, but remembers value for current directory]" "-x[sets the exit code to 1 if the build failed]" "--exit-code[sets the exit code to 1 if the build failed]" "--no-exit-code[sets the exit code to 1 if the build failed]" "-q[does not print anything]" "--quiet[does not print anything]" "--no-quiet[does not print anything]" "-p[sets the status code to 1 if the build is pending]" "--fail-pending[sets the status code to 1 if the build is pending]" "--no-fail-pending[sets the status code to 1 if the build is pending]" '*:file:_files' && return 0;;
      sync)      _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" "-c[only check the sync status]" "--check[only check the sync status]" "-b[will trigger sync but not block until sync is done]" "--background[will trigger sync but not block until sync is done]" "-f[will force sync, even if one is already running]" "--force[will force sync, even if one is already running]" '*:file:_files' && return 0;;
      token)     _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" '*:file:_files' && return 0;;
      version)   _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" '*:file:_files' && return 0;;
      whatsup)   _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" "-m[Only display my own repositories]" "--my-repos[Only display my own repositories]" '*:file:_files' && return 0;;
      whoami)    _arguments -s -S "-h[Display help]" "--help[Display help]" "-i[be interactive and colorful]" "--interactive[be interactive and colorful]" "--no-interactive[be interactive and colorful]" "-E[don't rescue exceptions]" "--explode[don't rescue exceptions]" "--no-explode[don't rescue exceptions]" "--skip-version-check[don't check if travis client is up to date]" "--skip-completion-check[don't check if auto-completion is set up]" "-e[Travis API server to talk to]" "--api-endpoint[Travis API server to talk to]" "-I[do not verify SSL certificate of API endpoint]" "--insecure[do not verify SSL certificate of API endpoint]" "--no-insecure[do not verify SSL certificate of API endpoint]" "--pro[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--com[short-cut for --api-endpoint 'https://api.travis-ci.com/']" "--org[short-cut for --api-endpoint 'https://api.travis-ci.org/']" "--staging[talks to staging system]" "-t[access token to use]" "--token[access token to use]" "--debug[show API requests]" "--debug-http[show HTTP(S) exchange]" "-X[use enterprise setup (optionally takes name for multiple setups)]" "--enterprise[use enterprise setup (optionally takes name for multiple setups)]" "--adapter[Faraday adapter to use for HTTP requests]" '*:file:_files' && return 0;;
    esac
  }
elif type compctl 1>/dev/null 2>/dev/null; then
  compctl -K _travis travis
  _travis()          { read -cA words && _travis_complete $((${#words} - 1)) "${words[2]}"; }
  _travis_commands() { reply=("accounts" "branches" "cache" "cancel" "console" "disable" "enable" "encrypt" "encrypt-file" "endpoint" "env" "help" "history" "init" "lint" "login" "logout" "logs" "monitor" "open" "pubkey" "raw" "report" "repos" "requests" "restart" "settings" "setup" "show" "sshkey" "status" "sync" "token" "version" "whatsup" "whoami"); }
  _travis_setup()    { reply=("anynines" "appfog" "artifacts" "biicode" "cloudcontrol" "cloudfiles" "cloudfoundry" "cloud66" "codedeploy" "deis" "divshot" "elasticbeanstalk" "engineyard" "gcs" "hackage" "heroku" "modulus" "npm" "ninefold" "nodejitsu" "openshift" "opsworks" "pypi" "releases" "rubygems" "s3" "sauce_connect"); }
  _travis_settings() { reply=(builds_only_with_travis_yml build_pushes build_pull_requests maximum_number_of_builds auto_cancel_pushes auto_cancel_pull_requests); }
  _travis_init()     { reply=("c" "clojure" "cpp" "erlang" "go" "groovy" "haskell" "java" "node_js" "objective-c" "perl" "php" "python" "ruby" "scala"); }
  _travis_option()   {
    case "${words[2]}" in
      accounts)  reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter");;
      branches)  reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter" "--repo" "-r" "--store-repo" "-R");;
      cache)     reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter" "--repo" "-r" "--store-repo" "-R" "--delete" "-d" "--branch" "-b" "--match" "-m" "--force" "-f");;
      cancel)    reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter" "--repo" "-r" "--store-repo" "-R");;
      console)   reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter" "--eval" "-x");;
      disable)   reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter" "--repo" "-r" "--store-repo" "-R");;
      enable)    reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter" "--repo" "-r" "--store-repo" "-R" "--skip-sync" "-s");;
      encrypt)   reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter" "--repo" "-r" "--store-repo" "-R" "--add" "-a" "--split" "--no-split" "-s" "--append" "-p" "--override" "-x");;
      encrypt-file) reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter" "--repo" "-r" "--store-repo" "-R" "--key" "-K" "--iv" "--decrypt" "-d" "--force" "-f" "--print-key" "-p" "--decrypt-to" "-w" "--add" "-a");;
      endpoint)  reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter" "--drop-default" "--set-default" "--github");;
      env)       reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter" "--repo" "-r" "--store-repo" "-R" "--public" "--no-public" "-P" "--private" "--no-private" "-p" "--unescape" "--no-unescape" "-u" "--force" "-f");;
      help)      reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check");;
      history)   reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter" "--repo" "-r" "--store-repo" "-R" "--after" "-a" "--pull-request" "-p" "--branch" "-b" "--limit" "-l" "--date" "-d" "--committer" "-c" "--all" "--no-all");;
      init)      reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter" "--repo" "-r" "--store-repo" "-R" "--skip-sync" "-s" "--force" "-f" "--skip-enable" "-k" "--print-conf" "-p" "--script" "--before-script" "--after-script" "--after-success" "--install" "--before-install" "--compiler" "--otp-release" "--go" "--jdk" "--node-js" "--perl" "--php" "--python" "--rvm" "--scala" "--env" "--gemfile");;
      lint)      reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter" "--quiet" "--no-quiet" "-q" "--exit-code" "--no-exit-code" "-x");;
      login)     reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter" "--github-token" "-g" "--auto-token" "-T" "--auto-password" "-p" "--auto" "-a" "--user" "-u" "--no-manual" "-M" "--list-github-token" "--skip-token-check");;
      logout)    reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter");;
      logs)      reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter" "--repo" "-r" "--store-repo" "-R" "--delete" "-d" "--force" "-f" "--stream" "--no-stream");;
      monitor)   reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter" "--my-repos" "-m" "--repo" "-r" "--notify" "--no-notify" "-n" "--builds" "-b" "--push" "-p" "--pull" "-P");;
      open)      reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter" "--repo" "-r" "--store-repo" "-R" "--github" "-g" "--print" "-p");;
      pubkey)    reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter" "--repo" "-r" "--store-repo" "-R" "--pem" "-p" "--fingerprint" "-f");;
      raw)       reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter" "--json" "--no-json");;
      report)    reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter" "--known-repos" "-r");;
      repos)     reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter" "--match" "-m" "--owner" "-o" "--name" "-n" "--active" "-a" "--inactive" "-A" "--admin" "-d" "--no-admin" "-D");;
      requests)  reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter" "--repo" "-r" "--store-repo" "-R" "--limit" "-l");;
      restart)   reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter" "--repo" "-r" "--store-repo" "-R");;
      settings)  reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter" "--repo" "-r" "--store-repo" "-R" "--keys" "--enable" "--disable" "-f" "--set" "-s" "--configure" "-c");;
      setup)     reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter" "--repo" "-r" "--store-repo" "-R" "--force" "-f");;
      show)      reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter" "--repo" "-r" "--store-repo" "-R");;
      sshkey)    reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter" "--repo" "-r" "--store-repo" "-R" "--delete" "-D" "--description" "-d" "--upload" "-u" "--stdin" "-s" "--check" "-c" "--generate" "-g" "--passphrase" "-p");;
      status)    reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter" "--repo" "-r" "--store-repo" "-R" "--exit-code" "--no-exit-code" "-x" "--quiet" "--no-quiet" "-q" "--fail-pending" "--no-fail-pending" "-p");;
      sync)      reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter" "--check" "-c" "--background" "-b" "--force" "-f");;
      token)     reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter");;
      version)   reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check");;
      whatsup)   reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter" "--my-repos" "-m");;
      whoami)    reply=("--help" "-h" "--interactive" "--no-interactive" "-i" "--explode" "--no-explode" "-E" "--skip-version-check" "--skip-completion-check" "--api-endpoint" "-e" "--insecure" "--no-insecure" "-I" "--pro" "--com" "--org" "--staging" "--token" "-t" "--debug" "--debug-http" "--enterprise" "-X" "--adapter");;
    esac
  }
elif type complete 1>/dev/null 2>/dev/null; then
  complete -F _travis travis
  _travis()          { _travis_complete "$COMP_CWORD" "${COMP_WORDS[1]}"; }
  _travis_commands() { COMPREPLY=( $(compgen -W "accounts branches cache cancel console disable enable encrypt encrypt-file endpoint env help history init lint login logout logs monitor open pubkey raw report repos requests restart settings setup show sshkey status sync token version whatsup whoami" -- "${COMP_WORDS[COMP_CWORD]}") ); }
  _travis_setup()    { COMPREPLY=( $(compgen -W "anynines appfog artifacts biicode cloudcontrol cloudfiles cloudfoundry cloud66 codedeploy deis divshot elasticbeanstalk engineyard gcs hackage heroku modulus npm ninefold nodejitsu openshift opsworks pypi releases rubygems s3 sauce_connect" -- "${COMP_WORDS[COMP_CWORD]}") ); }
  _travis_settings() { COMPREPLY=( $(compgen -W "builds_only_with_travis_yml build_pushes build_pull_requests maximum_number_of_builds auto_cancel_pushes auto_cancel_pull_requests" -- "${COMP_WORDS[COMP_CWORD]}") ); }
  _travis_init()     { COMPREPLY=( $(compgen -W ""c" "clojure" "cpp" "erlang" "go" "groovy" "haskell" "java" "node_js" "objective-c" "perl" "php" "python" "ruby" "scala"" -- "${COMP_WORDS[COMP_CWORD]}") ); }
  _travis_option()   {
    local options
    case "${COMP_WORDS[1]}" in
      accounts)  options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter";;
      branches)  options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter --repo -r --store-repo -R";;
      cache)     options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter --repo -r --store-repo -R --delete -d --branch -b --match -m --force -f";;
      cancel)    options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter --repo -r --store-repo -R";;
      console)   options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter --eval -x";;
      disable)   options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter --repo -r --store-repo -R";;
      enable)    options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter --repo -r --store-repo -R --skip-sync -s";;
      encrypt)   options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter --repo -r --store-repo -R --add -a --split --no-split -s --append -p --override -x";;
      encrypt-file) options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter --repo -r --store-repo -R --key -K --iv --decrypt -d --force -f --print-key -p --decrypt-to -w --add -a";;
      endpoint)  options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter --drop-default --set-default --github";;
      env)       options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter --repo -r --store-repo -R --public --no-public -P --private --no-private -p --unescape --no-unescape -u --force -f";;
      help)      options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check";;
      history)   options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter --repo -r --store-repo -R --after -a --pull-request -p --branch -b --limit -l --date -d --committer -c --all --no-all";;
      init)      options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter --repo -r --store-repo -R --skip-sync -s --force -f --skip-enable -k --print-conf -p --script --before-script --after-script --after-success --install --before-install --compiler --otp-release --go --jdk --node-js --perl --php --python --rvm --scala --env --gemfile";;
      lint)      options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter --quiet --no-quiet -q --exit-code --no-exit-code -x";;
      login)     options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter --github-token -g --auto-token -T --auto-password -p --auto -a --user -u --no-manual -M --list-github-token --skip-token-check";;
      logout)    options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter";;
      logs)      options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter --repo -r --store-repo -R --delete -d --force -f --stream --no-stream";;
      monitor)   options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter --my-repos -m --repo -r --notify --no-notify -n --builds -b --push -p --pull -P";;
      open)      options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter --repo -r --store-repo -R --github -g --print -p";;
      pubkey)    options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter --repo -r --store-repo -R --pem -p --fingerprint -f";;
      raw)       options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter --json --no-json";;
      report)    options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter --known-repos -r";;
      repos)     options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter --match -m --owner -o --name -n --active -a --inactive -A --admin -d --no-admin -D";;
      requests)  options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter --repo -r --store-repo -R --limit -l";;
      restart)   options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter --repo -r --store-repo -R";;
      settings)  options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter --repo -r --store-repo -R --keys --enable --disable -f --set -s --configure -c";;
      setup)     options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter --repo -r --store-repo -R --force -f";;
      show)      options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter --repo -r --store-repo -R";;
      sshkey)    options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter --repo -r --store-repo -R --delete -D --description -d --upload -u --stdin -s --check -c --generate -g --passphrase -p";;
      status)    options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter --repo -r --store-repo -R --exit-code --no-exit-code -x --quiet --no-quiet -q --fail-pending --no-fail-pending -p";;
      sync)      options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter --check -c --background -b --force -f";;
      token)     options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter";;
      version)   options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check";;
      whatsup)   options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter --my-repos -m";;
      whoami)    options="--help -h --interactive --no-interactive -i --explode --no-explode -E --skip-version-check --skip-completion-check --api-endpoint -e --insecure --no-insecure -I --pro --com --org --staging --token -t --debug --debug-http --enterprise -X --adapter";;
    esac
    COMPREPLY=( $(compgen -W "$options" -- "${COMP_WORDS[COMP_CWORD]}") )
  }
fi
