"""Anonymous push notification service for Nextcloud."""
# pylint: disable=import-error

import os
import docker
from flask import Flask, request
from ruamel.yaml import YAML


app = Flask(__name__)
client = docker.from_env()
yaml = YAML(typ="safe")


USERNAME = os.getenv("NC_USERNAME", "nimrod")
CONTAINER_NAME = os.getenv("NC_CONTAINER", "nextcloud_nextcloud_1")


@app.route("/ping")
def ping():
    """Healthcheck."""
    return "pong"


@app.route("/send", methods=["GET", "POST"])
def send_message():
    """Send a notification."""
    if request.method == "POST":
        if "message" in request.form:
            message = request.form["message"]
        else:
            message = request.get_data(as_text=True)
    else:
        message = request.args["message"]
    return message

    # result = container.exec_run(
    #    f"""./occ notification:generate -- {user_id} "{message}"""")
