#!/usr/bin/env python3
from sys import stderr
from requests import get
from parse import (  # pylint: disable=redefined-builtin,no-name-in-module
    compile,
)

BASE_URL = "https://challenge.hiringsolved.com/breadcrumbs/"
INITIAL_CRUMB = 19196
NEXT_PARSER = compile("the next breadcrumb is {:d}", case_sensitive=True)
SUBTRACT_PARSER = compile(
    "Yes. Subtract {:d} and keep going.", case_sensitive=True
)
ADD_PARSER = compile("Yes. Add {:d} and keep going.", case_sensitive=True)


if __name__ == "__main__":
    crumb = INITIAL_CRUMB
    previous = ""
    while True:
        r = get(BASE_URL + str(crumb))
        print(r.cookies.get("info"))
        print(r.text, file=stderr)
        if r.text == previous:
            print("Stuck on the same message.", file=stderr)
            exit(1)
        previous = r.text
        if NEXT_PARSER.search(r.text):
            crumb = NEXT_PARSER.search(r.text)[0]
        elif ADD_PARSER.search(r.text):
            crumb = crumb + ADD_PARSER.search(r.text)[0]
        elif SUBTRACT_PARSER.search(r.text):
            crumb = crumb - SUBTRACT_PARSER.search(r.text)[0]
        else:
            print("Don't know what to do.", file=stderr)
            exit(1)
