from __future__ import (absolute_import, division, print_function,
                        unicode_literals)
from fabric.api import (local, task, sudo, env, settings)

env.use_ssh_config = True


@task
def build():
    '''Build wheel.'''
    local('''python setup.py sdist bdist_wheel''')


@task
def clean():
    '''Clean cache, build files.'''
    local('''rm -rf *.egg-info build dist''')
    local('''find -name *.pyc -delete''')
    local('''find -name __pycache__ -type d -delete''')


@task
def upload():
    '''Build and upload to PyPI.'''
    build()
    local('''twine upload -s dist/*''')
