#!/usr/bin/env python
# pylint: disable=missing-docstring
from setuptools import setup, find_packages

setup(
    name="check_s3_bucket",
    version="0.1.1",
    description="""Check that a filename matching the regex was added to the
    bucket in the given time window.""",
    long_description=open("README.rst", "r").read(),
    url="https://www.shore.co.il/git/check_s3_bucket",
    author="Nimrod Adar",
    author_email="nimrod@shore.co.il",
    license="MIT",
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: System Administrators",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.4",
        "Programming Language :: Python :: 3.5",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 2",
        "Programming Language :: Python :: 2.7",
        "Topic :: Utilities",
        "License :: OSI Approved :: MIT License",
    ],
    keywords="nagios s3 aws monitoring",
    packages=find_packages(),
    install_requires=["python-dateutil", "botocore"],
    entry_points={"console_scripts": ["check_s3_bucket=check_s3_bucket:main"]},
)
