#!/usr/bin/env python
from setuptools import setup, find_packages
from check_mysql_slave import DESCRIPTION

setup(
    name="check_mysql_slave",
    version=open("VERSION", "r").read(),
    description=DESCRIPTION,
    long_description=open("README.rst", "r").read(),
    url="https://git.shore.co.il/nimrod/check_mysql_slave",
    author="Nimrod Adar",
    author_email="nimrod@shore.co.il",
    license="MIT",
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: System Administrators",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 2",
        "Programming Language :: Python :: 2.7",
        "Topic :: Utilities",
        "License :: OSI Approved :: MIT License",
    ],
    keywords="nagios mysql slave replication monitoring",
    packages=find_packages(),
    install_requires=["mysqlclient"],
    entry_points={
        "console_scripts": ["check_mysql_slave=check_mysql_slave:main"],
    },
)
