# -*- coding: utf-8 -*- #
# pylint: disable=import-error
from __future__ import unicode_literals

import seafoam

AUTHOR = "Nimrod Adar"
SITENAME = "My notes and ramblings"
SITEURL = "http://localhost:8080"

PATH = "content"

TIMEZONE = "Asia/Jerusalem"

DEFAULT_LANG = "en"

# Feed generation is usually not desired when developing
FEED_ALL_ATOM = "feeds/all.atom.xml"
CATEGORY_FEED_ATOM = None
TRANSLATION_FEED_ATOM = None
AUTHOR_FEED_ATOM = None
AUTHOR_FEED_RSS = None

# Blogroll
LINKS = ()

DEFAULT_PAGINATION = 3

# Uncomment following line if you want document-relative URLs when developing
RELATIVE_URLS = True
DIRECT_TEMPLATES = ("index", "archives")
DISPLAY_CATEGORIES_ON_MENU = False
DISPLAY_PAGES_ON_MENU = True
MENUITEMS = (("Code", "https://git.shore.co.il/explore/", None),)
THEME = seafoam.get_path()
BOOTSTRAP_THEME = "seafoam"
DOCUTIL_CSS = True
CC_LICENSE = "CC-BY-NC-ND"

PLUGINS = [
    "pelican.plugins.jinja_filters",
    "pelican.plugins.image_process",
]

IMAGE_PROCESS = {}

TAGS_SAVE_AS = ""
TAG_SAVE_AS = ""
HIDE_SIDEBAR = True
STATIC_PATHS = ["static"]
ARTICLE_URL = "{slug}/"
DELETE_OUTPUT_DIRECTORY = True

SLUGIFY_SOURCE = "basename"
ARTICLE_SAVE_AS = "{slug}/index.html"

LOCALE = "C.UTF-8"
