#!/usr/bin/env python
from fabric.api import task, local, settings

@task
def publish ():
    build ()
    for dist in ['wheezy', 'jessie', 'sid']:
         local ('''reprepro includedeb ''' + dist + ''' ../python3-vlc_*.deb''')
    local ('''fab -f $REPREPRO_BASE_DIR/fabfile.py publish''')
    clean ()

@task
def build ():
    local ('''dpkg-buildpackage''')

@task
def clean ():
    with settings(warn_only=True):
        local ('''rm vlc.py''')
        local ('''rm ../python3-vlc_*''')
        local ('''rm -r debian/python3-vlc.substvars debian/python3-vlc.prerm.debhelper\
        debian/python3-vlc.postinst.debhelper debian/python3-vlc.debhelper.log\
        debian/python3-vlc debian/files''')
        local ('''rm fabfile.pyc''')
