#!/usr/bin/env python3
from PyQt4 import QtGui
from PyQt4 import QtCore
try:
    from dcpman.dcp import DCP
except:
    from dcp import DCP
try:
    from dcpman import ui #autogenerated file from Qt Designer to setup the window
except:
    import ui
import sys
from os.path import basename
import syslog
import time

class verifyThread(QtCore.QThread):
    '''A seperate thread to verify the DCP (IO intensive).

    Verify the assets of DCP (reads all of the files to
    calculate the hash) in a seperate thread from the GUI to keep the GUI
    responsive. At the end update the verifyLine test to reflect the result.'''
    def run(self):
        '''The action the thread takes.'''
        result = dcp.verify()
        try:
            result = dcp.verify()
            if result:
                window.verifyLine.setText('OK')
                syslog.syslog (syslog.LOG_INFO, time.ctime () +\
                        directoryname + ' verification succeeded.')
            else:
                window.verifyLine.setText('Corrupted!')
                syslog.syslog (syslog.LOG_INFO, time.ctime () +\
                        directoryname + ' verification failed.')
        except BaseException as exception:
            window.verifyLine.setText(str(exception))


def verify_in_thread():
    '''Verifys the DCP in a differenet thread.

    Firstly disable the button and change the verifyLine to reflect that the
    verification is running (in the same thread to update the window immediately
    then calls the seperate thread to verify the assets of DCP.'''
    window.verifyLine.setText('Verifying, please wait...')
    window.verifyButton.setEnabled(False)
    thread.start()


if __name__ == '__main__':
    syslog.openlog (ident = 'dcpman', facility = syslog.LOG_USER)
    app = QtGui.QApplication(sys.argv)
    icon = QtGui.QIcon('/usr/share/icons/oxygen/16x16/apps/kmplayer.png')
    app.setWindowIcon(icon)
    directory = QtGui.QFileDialog.getExistingDirectory( \
            caption='Please select the location of the DCP')
    directoryname = basename (directory)
    mainwindow = QtGui.QMainWindow()
    window = ui.Ui_MainWindow()
    window.setupUi(mainwindow)
    thread = verifyThread()
    try:
        dcp = DCP(directory)
        try:
            window.nameLine.setText(dcp.name)
            syslog.syslog (syslog.LOG_INFO, time.ctime () + directoryname +\
                    ' parsed.')
        except AttributeError:
            window.nameLine.setText (basename (directory))
            syslog.syslog (syslog.LOG_INFO, time.ctime () + directoryname +\
                    ' parsed.')
        if dcp.signed:
             syslog.syslog (syslog.LOG_INFO, time.ctime () + directoryname +\
                     ' is signed.')
        else:
            syslog.syslog (syslog.LOG_INFO, time.ctime () + directoryname +\
                    ' is not sigend.')
        syslog.syslog (syslog.LOG_INFO, time.ctime () + directoryname +\
                ' duration is ' + str (dcp.duration))
        if dcp.signed and dcp.duration == 0:
            window.encryptedLine.setText('Most likely')
        elif dcp.signed or dcp.duration == 0:
            window.encryptedLine.setText ('Probably')
        else:
            window.encryptedLine.setText('Probably not')
        window.verifyLine.setText('Click button to start verification')
        window.verifyButton.clicked.connect(verify_in_thread)
    except BaseException as exception:
        window.nameLine.setText(str(exception))
        window.verifyButton.setEnabled(False)
    mainwindow.show()
    mainwindow.activateWindow()
    exit(app.exec_())
