#!/bin/sh
set -eux
[ "$(whoami)" = "root" ] || { echo "Not root, exiting."; exit 1; }
apt-get update
apt-get install -y python3-pip curl sharutils parted xfsprogs procps
pip3 install docker-compose
curl -fsSL get.docker.com | sh
usermod -aG docker ubuntu
while [ ! -b /dev/nvme0n1 ]
do
    echo Waiting for /dev/nvme0n1 to be available
    sleep 2
done
parted /dev/nvme0n1 --script mklabel gpt mkpart primary 0% 100%
while [ ! -b /dev/nvme0n1p1 ]
do
    echo Waiting for /dev/nvme0n1p1 to be available
    sleep 2
done
mkfs.xfs /dev/nvme0n1p1 -L data
mkdir -p /opt/ELK/data
echo '/dev/nvme0n1p1 /opt/ELK/data xfs defaults,discard 0 0' >> /etc/fstab
mount -a
chown 1000:1000 /opt/ELK/data
sysctl vm.max_map_count=262144
cd /opt/ELK
uudecode << EOF
INSERT BINARY HERE
EOF
tar -xzf userdata.tar.gz
docker-compose up -d
